package org.msh.tb.bd.tbforms.indicator.tb11;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb11.TBForm11Block3HIVActivitiesQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.indicators.core.Indicator2D;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.Map;


/**
 * Generate indicator TB 11 form (HIV CPT and ART table)
 * @author Mauricio Santos
 *
 */
@Name("TBForm11Block3ActivitiesHome")
public class TBForm11Block3ActivitiesHome extends TBForm11 {

    @In(create=true)
    EntityManager entityManager;
    @In(create=true)
    Map<String, String> messages;

    TbFormQuery formQuery;

    @Override
    protected void createIndicators() {
        createInterfaceFields();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        for(Object[] o : result){
            String type = (String) o[0];
            Gender g = (Gender) o[1];
            Long qtd = (Long) o[2];

            String complement = g.equals(Gender.MALE) ? "-M" : "-F";

            addValue(type+complement, messages.get("manag.gender.male"), messages.get("manag.tbform11.allTbCases"), qtd.floatValue());
        }
    }

    private void createInterfaceFields(){
        addValue("TOTAL-M", messages.get("manag.gender.male"), messages.get("manag.tbform11.allTbCases"), new Float(0));
        addValue("TOTAL-F", messages.get("manag.gender.female"), messages.get("manag.tbform11.allTbCases"), new Float(0));
        addValue("ART-M", messages.get("manag.gender.male"), messages.get("manag.tbform11.allTbCases"), new Float(0));
        addValue("ART-F", messages.get("manag.gender.female"), messages.get("manag.tbform11.allTbCases"), new Float(0));
        addValue("CPT-M", messages.get("manag.gender.male"), messages.get("manag.tbform11.allTbCases"), new Float(0));
        addValue("CPT-F", messages.get("manag.gender.female"), messages.get("manag.tbform11.allTbCases"), new Float(0));
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm11Block3HIVActivitiesQuery();
        }
        return formQuery;
    }
}
